/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.CEADescriptor;
import com.quantumdata.edideditor.DescriptorType;
import java.util.ArrayList;

public class CEAGenericVSDB
extends CEADescriptor {
    private int[] IEEE_header;
    private ArrayList<Integer> payload;

    public CEAGenericVSDB() {
        super(DescriptorType.GENERIC_VSDB_DES, 0);
    }

    public void setIEEEHeader(String string) {
        if (this.IEEE_header == null) {
            this.IEEE_header = new int[3];
        }
        this.IEEE_header[2] = Integer.parseInt(string.substring(0, 2), 16);
        this.IEEE_header[1] = Integer.parseInt(string.substring(2, 4), 16);
        this.IEEE_header[0] = Integer.parseInt(string.substring(4, 6), 16);
        this.mySize = 3;
    }

    public String getIEEEHeader() {
        String string = new String();
        string = string.concat(String.format("%02X", this.IEEE_header[2]));
        string = string.concat(String.format("%02X", this.IEEE_header[1]));
        string = string.concat(String.format("%02X", this.IEEE_header[0]));
        return string;
    }

    public void setPayload(String string) {
        if (this.payload == null) {
            this.payload = new ArrayList(string.length());
        } else {
            this.payload.clear();
        }
        for (int i = 0; i < string.length(); i += 2) {
            this.payload.add(new Integer(Integer.parseInt(string.substring(i, i + 2), 16)));
            ++this.mySize;
        }
    }

    public void uploadDescriptorData(String string) {
        if (this.IEEE_header == null) {
            this.IEEE_header = new int[3];
        }
        this.IEEE_header[0] = Integer.parseInt(string.substring(0, 2), 16);
        this.IEEE_header[1] = Integer.parseInt(string.substring(2, 4), 16);
        this.IEEE_header[2] = Integer.parseInt(string.substring(4, 6), 16);
        this.mySize = 3;
        if (this.payload == null) {
            this.payload = new ArrayList(string.length() - 6);
        }
        for (int i = 6; i < string.length(); i += 2) {
            this.payload.add(new Integer(Integer.parseInt(string.substring(i, i + 2), 16)));
            ++this.mySize;
        }
    }

    public String getIEEE() {
        String string = new String(String.format("%02X", this.IEEE_header[0]));
        string = string.concat(String.format("%02X", this.IEEE_header[1]));
        string = string.concat(String.format("%02X", this.IEEE_header[2]));
        return string;
    }

    public String getPayload() {
        String string = new String();
        if (this.payload != null) {
            for (int i = 0; i < this.payload.size(); ++i) {
                string = string.concat(String.format("%02X", this.payload.get(i)));
            }
        }
        return string;
    }

    public String extractDescriptorData() {
        String string = new String(this.getIEEE());
        string = string.concat(this.getPayload());
        return string;
    }
}

